function pdf = LN_density(x,mu,sigma)
%==========================================================================================
% This function computes the pdf of the Lognormal distribution with parameters
% mu and sigma at xval
%==========================================================================================
%INPUT:
%   xval: points to evaluate the pdf of a lognormal, must be a column vector
%   mu: mean of Lognormal density
%   sigma: scale parameter of Lognormal density (see Eq. (5) of Li, Nolte and Pham (2023))
%
%OUTPUT:
%   pdf: pdf evaluated at xval
%==========================================================================================
% This ver: 2023/05/24
% Authors: Yifan Li (yifan.li@manchester.ac.uk)
%          Ingmar Nolte (i.nolte@lancaster.ac.uk)
%          Manh Pham (m.c.pham@lancaster.ac.uk)
% Reference: Li, Y., Nolte, I., and Pham, M. C. (2023). Parametric Risk-Neutral 
%          Density Estimation via Finite Lognormal-Weibull Mixtures
%========================================================================================== 

pdf = 1./(sigma.*x.*sqrt(2*pi)).*exp(-(log(x) - log(mu) +sigma.^2/2).^2/2./sigma.^2 );   

end
